/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#if !defined _cprl_h_
#define _cprl_h_

#define CPRL_IOC_MAGIC      (0xD3)

enum {
	C_GET_HWSECRET = 51,
	C_SET_FRAMEKEY,
	C_SET_DIVXDRMMODE,
	C_SET_DIVXPLUSDRMMODE,
	C_EXEC_NETFLIX,
	C_EXEC_WMPD,
	C_CALC_HMAC_MEM,
	C_UPDATE_DEVKEY,
	C_EXEC_WIDEVINE,
	C_EXEC_VUDU,
	C_MAKE_RAND,
	C_MAKE_DEVID,
	CPRL_SN_LOCAL_SET_ENCKEY,
	CPRL_SN_LOCAL_SET_STREAMINFO,
	CPRL_SN_LOCAL_SET_CNVCPI_RULE,
	CPRL_SN_LOCAL_CIPHER_DATA,
	CPRL_SN_CALC_HASH,
	CPRL_SN_REENC_DEVKEY,
};

#if 1
enum {
		
	CPRL_SN_PLAYREADY_MAKE_DEVKEY_PAIR     = 0x01, 
	CPRL_SN_PLAYREADY_MAKE_CHALLENGEKEY    = 0x02, 
	CPRL_SN_PLAYREADY_ENCRYPT_CHALLENGE    = 0x03, 
	CPRL_SN_PLAYREADY_ENCRYPT_CHALLENGEKEY = 0x04, 
	CPRL_SN_PLAYREADY_GENERATE_SIGN        = 0x05, 
	CPRL_SN_PLAYREADY_SET_CONTENTKEY       = 0x06, 
	CPRL_SN_PLAYREADY_VERIFY_LICENSE       = 0x07, 
	CPRL_SN_PLAYREADY_SET_PAYLOADINFO      = 0x08, 
	CPRL_SN_PLAYREADY_CHECK_DEVKEY         = 0x09, 
	CPRL_SN_PLAYREADY_VERIFY_SIGN            = 0x0A, 
	CPRL_SN_PLAYREADY_GENERATE_KEYFILE_SIGN  = 0x0B, 
	CPRL_SN_PLAYREADY_MAKE_SST_KEY           = 0x0C, 
	CPRL_SN_PLAYREADY_MAKE_SST_PASSWD        = 0x0D, 
	CPRL_SN_PLAYREADY_SET_SST_PASSWD         = 0x0E, 
	CPRL_SN_PLAYREADY_CALC_SST_HASH          = 0x0F, 

	CPRL_SN_DEBUG_CMD = 0xC9,   

	CPRL_SN_OPEN      = 0x100,  
	CPRL_SN_CLOSE,              
};
#endif

#define CPRL_MKCMD_IO(name) \
	RTSC_IOC_IO( CPRL_IOC_MAGIC, (CPRL_SN_##name) )
#define CPRL_MKCMD_IOW(name) \
	RTSC_IOC_IOW( CPRL_IOC_MAGIC, (CPRL_SN_##name), RTSC_STPC_##name )
#define CPRL_MKCMD_IOR(name) \
	RTSC_IOC_IOR( CPRL_IOC_MAGIC, (CPRL_SN_##name), RTSC_STPC_##name )
#define CPRL_MKCMD_IOWR(name) \
	RTSC_IOC_IOWR( CPRL_IOC_MAGIC, (CPRL_SN_##name), RTSC_STPC_##name )

#define STPC_GET_HWSECRET	\
			_IOR ( STPC_IOC_MAGIC, C_GET_HWSECRET, void * )
#define STPC_SET_FRAMEKEY	\
			_IOW ( STPC_IOC_MAGIC, C_SET_FRAMEKEY, void * )
#define STPC_SET_DIVXDRMMODE	\
			_IOW ( STPC_IOC_MAGIC, C_SET_DIVXDRMMODE, void * )
#define STPC_SET_DIVXPLUSDRMMODE	\
			_IOW ( STPC_IOC_MAGIC, C_SET_DIVXPLUSDRMMODE, void * )
#define STPC_EXEC_NETFLIX	\
			_IOW ( STPC_IOC_MAGIC, C_EXEC_NETFLIX, void * )
#define STPC_EXEC_WMPD	\
			_IOW ( STPC_IOC_MAGIC, C_EXEC_WMPD, void * )
#define STPC_EXEC_WIDEVINE	\
			_IOW ( STPC_IOC_MAGIC, C_EXEC_WIDEVINE, void * )
#define STPC_EXEC_VUDU	\
			_IOW ( STPC_IOC_MAGIC, C_EXEC_VUDU, void * )
#define STPC_MAKE_RAND		\
			_IOWR ( STPC_IOC_MAGIC,  C_MAKE_RAND, void * )
#define STPC_MAKE_DEVID		\
			_IOWR ( STPC_IOC_MAGIC,  C_MAKE_DEVID, void * )
#define STPC_CALC_HMAC_MEM	\
			_IOWR ( STPC_IOC_MAGIC,  C_CALC_HMAC_MEM, void * )
#define STPC_UPDATE_DEVKEY	\
			_IOWR ( STPC_IOC_MAGIC,  C_UPDATE_DEVKEY, void * )

#define STPC_LOCAL_SET_ENCKEY      CPRL_MKCMD_IOW (LOCAL_SET_ENCKEY)
#define STPC_LOCAL_SET_STREAMINFO  CPRL_MKCMD_IOW (LOCAL_SET_STREAMINFO)
#define STPC_LOCAL_SET_CNVCPI_RULE CPRL_MKCMD_IOW (LOCAL_SET_CNVCPI_RULE)
#define STPC_LOCAL_CIPHER_DATA     CPRL_MKCMD_IOW (LOCAL_CIPHER_DATA)
#define STPC_CALC_HASH             CPRL_MKCMD_IOWR(CALC_HASH)
#define STPC_REENC_DEVKEY          CPRL_MKCMD_IOWR(REENC_DEVKEY)

#if 1
	
#define STPC_PLAYREADY_MAKE_DEVKEY_PAIR     CPRL_MKCMD_IOR (PLAYREADY_MAKE_DEVKEY_PAIR)
#define STPC_PLAYREADY_MAKE_CHALLENGEKEY    CPRL_MKCMD_IOR (PLAYREADY_MAKE_CHALLENGEKEY)
#define STPC_PLAYREADY_ENCRYPT_CHALLENGE    CPRL_MKCMD_IOWR(PLAYREADY_ENCRYPT_CHALLENGE)
#define STPC_PLAYREADY_ENCRYPT_CHALLENGEKEY CPRL_MKCMD_IOR (PLAYREADY_ENCRYPT_CHALLENGEKEY)
#define STPC_PLAYREADY_GENERATE_SIGN        CPRL_MKCMD_IOWR(PLAYREADY_GENERATE_SIGN)
#define STPC_PLAYREADY_SET_CONTENTKEY       CPRL_MKCMD_IOW (PLAYREADY_SET_CONTENTKEY)
#define STPC_PLAYREADY_VERIFY_LICENSE       CPRL_MKCMD_IOW (PLAYREADY_VERIFY_LICENSE)
#define STPC_PLAYREADY_SET_PAYLOADINFO      CPRL_MKCMD_IOW (PLAYREADY_SET_PAYLOADINFO)
#define STPC_PLAYREADY_CHECK_DEVKEY         CPRL_MKCMD_IOW (PLAYREADY_CHECK_DEVKEY)
#define STPC_PLAYREADY_VERIFY_SIGN           CPRL_MKCMD_IOW (PLAYREADY_VERIFY_SIGN)
#define STPC_PLAYREADY_GENERATE_KEYFILE_SIGN CPRL_MKCMD_IOWR(PLAYREADY_GENERATE_KEYFILE_SIGN)
#define STPC_PLAYREADY_MAKE_SST_KEY          CPRL_MKCMD_IOR (PLAYREADY_MAKE_SST_KEY)
#define STPC_PLAYREADY_MAKE_SST_PASSWD       CPRL_MKCMD_IOWR(PLAYREADY_MAKE_SST_PASSWD)
#define STPC_PLAYREADY_SET_SST_PASSWD        CPRL_MKCMD_IOW (PLAYREADY_SET_SST_PASSWD)
#define STPC_PLAYREADY_CALC_SST_HASH         CPRL_MKCMD_IOWR(PLAYREADY_CALC_SST_HASH)
#endif

enum {
	STPC_VERIFY_SIGN_DEVICE,
	STPC_SET_CONTENTKEY,
	STPC_SET_KPE,
	STPC_SET_KCE,
	STPC_SET_KPH,
	STPC_SET_KCH,
	STPC_ENCRYPT_REQUEST_V3,
	STPC_ENCRYPT_REQUEST,
	STPC_DECRYPT_RESPONSE,
	STPC_MAKE_RC,
	STPC_MAKE_CLIENTKEY,
	STPC_DEC_LICENSE,
	STPC_SET_PAYLOADINFO,
	STPC_VERIFY_CONTENTKEY,
	STPC_MAKE_DEVKEY_PAIR,
	STPC_MAKE_DEVCERT_SIGN,
	STPC_MAKE_FALLBACKCERT_SIGN,
	STPC_CHECK_DEVKEY,
	STPC_WV_SET_DEVKEY,
	STPC_WV_DECRYPT_KEYBOX,
	STPC_WV_SET_ASSETKEY,
	STPC_WV_DERIVE_CW,
	STPC_VUDU_CA_SETUP,
	STPC_VUDU_CA_LOAD,
};

enum stpc_cprl_cpskey_type {   
        STPC_CPSKEY_ALL,		
        STPC_CPSKEY_DTCPIP,		
        STPC_CPSKEY_MARLINBB_PRIV,	
        STPC_CPSKEY_MARLINBB_SECRET,	
        STPC_CPSKEY_MARLINBB_DEVKEY_SET,
	STPC_CPSKEY_HDCP,		
};
enum cprl_fact_cpskey_type {
	CPRL_CPSKEY_ALL,
	CPRL_CPSKEY_DTCPIP,
	CPRL_CPSKEY_MARLINBB_SECRET,
	CPRL_CPSKEY_MARLINBB_PRIV,
	CPRL_CPSKEY_MARLINBB_DEVKEY_SET,
	CPRL_CPSKEY_HDCP,
};

#define RTSC_WMPD_GROUP		(0x01)
#define RTSC_WMPD_FALLBACK	(0x02)
#define RTSC_WMPD_DEVICE	(0x03)

#define RTSC_DIVXPLUS_AUDIONUM	8
#define RTSC_DIVXPLUS_VIDEONUM	1

#define RTSC_HMAC_SHA1		(0x01)
#define RTSC_HMAC_SHA256	(0x02)

#define RTSC_KTYPE_NETFLIX	(0x0D)
#define RTSC_KTYPE_WMPD		(0x0E)
#define RTSC_KTYPE_WV		(0x0F)

enum stpc_cprl_algo {
	STPC_ALGO_TS_AES,
	STPC_ALGO_AES128,
};

enum stpc_cprl_block_mode {
	STPC_BLK_CBC,
};

enum stpc_cprl_hash_type {
	STPC_HASH_SHA1,
	STPC_HASH_SHA256,
};

#if 1	
enum stpc_cprl_playready_key_type {  
	STPC_PLAYREADY_MODEL,    
	STPC_PLAYREADY_DEVICE,   
};
enum stpc_cprl_checksum_mode {       
	STPC_CHECKSUM_CHECK,     
	STPC_CHECKSUM_NOCHECK,   
};
#endif

#define STPC_PHASE_START    (1<<0)
#define STPC_PHASE_CONTINUE (1<<1)
#define STPC_PHASE_END      (1<<2)

typedef struct {
	UINT8		hw_secret[32];
} RTSC_STPC_GET_HWSECRET;


typedef struct {
	UINT32		seq_id;
	UINT32		*frame_key;
} RTSC_STPC_SET_FRAMEKEY;

typedef struct {
	UINT32		*data;
	UINT32		key_num;
} RTSC_FRAMEKEY;

typedef struct {
	UINT8		v_num[2];
	UINT8		a_num[2];
	UINT8		spu_num[2];
	UINT32		aenc_offset;
	UINT32		aenc_size;
} RTSC_STPC_SET_DIVXDRMMODE;


typedef struct {
	UINT32		num_a;
	UINT64		tracknum_a[RTSC_DIVXPLUS_AUDIONUM];
	UINT32		num_v;
	UINT64		tracknum_v[RTSC_DIVXPLUS_VIDEONUM];
	UINT32		aenc_offset;
	UINT32		aenc_size;
} RTSC_STPC_SET_DIVXPLUSDRMMODE;


typedef struct {
	UINT32		sub_ope;
	UINT32		*para;
} RTSC_STPC_EXEC_NETFLIX;

typedef struct {
	UINT32		*kce_adr;	
	UINT32		kce_size;	
} RTSC_STPC_NETFLIX_SET_KCE;

typedef struct {
	UINT32		*kch_adr;	
	UINT32		kch_size;	
} RTSC_STPC_NETFLIX_SET_KCH;

typedef struct {
	UINT32 		*rc_adr;
	UINT32 		*rc_size;
} RTSC_STPC_NETFLIX_MAKE_RC;

typedef struct {
	UINT32 		*rs_adr;	
	UINT32 		rs_size;	
	UINT32		*kce_adr;	
	UINT32		kce_size;	
	UINT32		*kch_adr;	
	UINT32		kch_size;	
} RTSC_STPC_NETFLIX_MAKE_CLIENTKEY;

typedef struct {
	UINT32 		*src;
	UINT32		*dst;
	UINT32		size;
	UINT32	 	*iv_adr;
	UINT32		*iv_size;
} RTSC_STPC_NETFLIX_ENCRYPT_REQUEST;

typedef struct {
	UINT32 		*src;
	UINT32		*dst;
	UINT32		size;
	UINT32	 	*iv_adr;
	UINT32		iv_size;
} RTSC_STPC_NETFLIX_ENCRYPT_REQUEST_V3;

typedef struct {
	UINT32 		*src;
	UINT32		*dst;
	UINT32		size;
	UINT32 		*iv_adr;
	UINT32		iv_size;
} RTSC_STPC_NETFLIX_DECRYPT_RESPONSE;




typedef struct {
	UINT32 		*esn;
	UINT32 		esn_len;
} RTSC_STPC_NETFLIX_GET_ESN;




typedef struct {
	UINT32		sub_ope;
	UINT32		*para;
} RTSC_STPC_EXEC_WMPD;




typedef struct {
	UINT32 		*src;
	UINT32		*dst;
	UINT32		size;
} RTSC_STPC_WMPD_DECRYPT_LICENSE;




typedef struct {
	UINT32 		*key;
	UINT32 		key_size;
	UINT32 		*checksum;
	UINT32 		checksum_size;
	UINT32 		*auth_id;
} RTSC_STPC_WMPD_SET_CONTENTKEY;




typedef struct {
	UINT32 		auth_id;
	UINT32 		*pubkey;
	UINT32 		pubkey_size;
	UINT32 		*sign;
	UINT32 		sign_size;
} RTSC_STPC_WMPD_VERIFY_CONTENTKEY;




typedef struct {
	UINT32		header_size;
	UINT32		frame_size;
	UINT32		footer_size;
	UINT8		payloadkey[8];
}RTSC_WMPD_PAYLOADINFO;

typedef struct {
	UINT32 		auth_id;
	UINT32		num;
	UINT32		*payload_info;
} RTSC_STPC_WMPD_SET_PAYLOADINFO;




typedef struct {
	UINT32 		*hash_adr;
	UINT32 		hash_size;
	UINT32 		*sign_adr;
	UINT32 		sign_size;
	UINT32 		*pubkey_adr;
	UINT32 		pubkey_size;
} RTSC_STPC_WMPD_VERIFY_SIGN_DEVICE;




typedef struct {
	UINT32 		*privkey_adr;
	UINT32 		privkey_size;
	UINT32 		*pubkey_adr;
	UINT32 		pubkey_size;
} RTSC_STPC_WMPD_MAKE_DEVKEY_PAIR;




typedef struct {
	UINT32 		*data_adr;
	UINT32 		data_size;
	UINT32 		*sign_adr;
	UINT32 		sign_size;
} RTSC_STPC_WMPD_MAKE_DEVCERT_SIGN;




typedef struct {
	UINT32 		*data_adr;
	UINT32 		data_size;
	UINT32 		*sign_adr;
	UINT32 		sign_size;
} RTSC_STPC_WMPD_MAKE_FALLBACKCERT_SIGN;




typedef struct {
	UINT32 		*pub_key;
	UINT32 		pub_len;
	UINT32 		type;
} RTSC_STPC_WMPD_CHECK_DEVKEY;

typedef struct {
	UINT32		sub_ope;
	UINT32		*para;
} RTSC_STPC_EXEC_WIDEVINE;

typedef struct {
	UINT32		*keybox_adr;
	UINT32		keybox_size;
} RTSC_STPC_WV_DECRYPT_KEYBOX;

typedef struct {
	UINT32		*assetkey_adr;
	UINT32		assetkey_size;
	UINT32		*auth_id;
} RTSC_STPC_WV_SET_ASSETKEY;

typedef struct {
	UINT32		auth_id;
	UINT32		*ecm_adr;
	UINT32		ecm_size;
	UINT32		*cci_adr;
	UINT32		cci_size;
} RTSC_STPC_WV_DERIVE_CW;

typedef struct {
	UINT32		sub_ope;
	UINT32		*para;
} RTSC_STPC_EXEC_VUDU;

typedef struct RTSC_STPC_VUDU_CA_SETUP {
	UINT32		*iv;
	UINT32 		*uniqkey;
} RTSC_STPC_VUDU_CA_SETUP;

typedef struct RTSC_STPC_VUDU_CA_LOAD {
	UINT32 		*oddkey;
	UINT32		*evenkey;
} RTSC_STPC_VUDU_CA_LOAD;

typedef struct RTSC_STPC_MAKE_RAND {
	UINT32*		seed;
	UINT32*		rand;
	UINT32		size;
} RTSC_STPC_MAKE_RAND;


typedef struct RTSC_STPC_MAKE_DEVID {
	UINT32*		devid;
	UINT32		size;
} RTSC_STPC_MAKE_DEVID;

typedef struct {
	UINT32		type;
	UINT32		phase;
	UINT32		*adr;
	UINT32		length;
	UINT32		*data;
	UINT32		data_size;
	UINT32		*result;
	UINT32		result_size;
} RTSC_STPC_CALC_HMAC_MEM;

typedef struct {
	UINT32	type;
	UINT8	*key;
	UINT32	size;
} RTSC_STPC_UPDATE_DEVKEY;

typedef struct RTSC_STPC_LOCAL_SET_ENCKEY {
	UINT8           enckey1[16];
	UINT8           enckey2[16];
} RTSC_STPC_LOCAL_SET_ENCKEY;

typedef struct RTSC_STPC_LOCAL_SET_STREAMINFO {
	UINT32          algo;
	UINT32          block_mode;
	UINT32          chain_size;
} RTSC_STPC_LOCAL_SET_STREAMINFO;

typedef struct RTSC_STPC_LOCAL_SET_CNVCPI_RULE {
	UINT32          cpi_mode;
	UINT32          cpi;
} RTSC_STPC_LOCAL_SET_CNVCPI_RULE;

typedef struct RTSC_STPC_LOCAL_CIPHER_DATA {
	RTSC_DATAPOS    src;
	RTSC_DATAPOS    dst;
	UINT32          length;
	UINT32          mode;
	UINT32          algo;
	UINT32          block_mode;
	UINT32          chain_size;
} RTSC_STPC_LOCAL_CIPHER_DATA;

typedef struct RTSC_STPC_CALC_HASH {
        UINT32          type;
        RTSC_DATAPOS    data;
        UINT32          length;
        UINT32          phase;
        UINT8           *state;
        UINT32          state_size;
        UINT8           *hash;
        UINT32          hash_size;
} RTSC_STPC_CALC_HASH;

#if 1	
typedef struct RTSC_STPC_PLAYREADY_MAKE_DEVKEY_PAIR {
	UINT8  privkey[32];     
	UINT8  pubkey[64];      
} RTSC_STPC_PLAYREADY_MAKE_DEVKEY_PAIR;
typedef struct RTSC_STPC_PLAYREADY_MAKE_CHALLENGEKEY {
	UINT8  iv[16];            
} RTSC_STPC_PLAYREADY_MAKE_CHALLENGEKEY;
typedef struct RTSC_STPC_PLAYREADY_ENCRYPT_CHALLENGE {
	UINT8  *challenge;      
	UINT32 size;            
} RTSC_STPC_PLAYREADY_ENCRYPT_CHALLENGE;
typedef struct RTSC_STPC_PLAYREADY_ENCRYPT_CHALLENGEKEY {
	UINT8  challengekey[128]; 
} RTSC_STPC_PLAYREADY_ENCRYPT_CHALLENGEKEY;
typedef struct RTSC_STPC_PLAYREADY_GENERATE_SIGN {
	UINT32 type;            
	UINT8  privkey[32];     
	UINT8  hash[32];        
	UINT8  sign[64];        
} RTSC_STPC_PLAYREADY_GENERATE_SIGN;
typedef struct RTSC_STPC_PLAYREADY_SET_CONTENTKEY {
	UINT8  privkey[32];     
	UINT8  contentkey[128]; 
	UINT8  checksum[8];     
	UINT8  checksum_valid;  
	UINT8  kid[16];         
} RTSC_STPC_PLAYREADY_SET_CONTENTKEY;
typedef struct RTSC_STPC_PLAYREADY_VERIFY_LICENSE {
	UINT8  *license;        
	UINT32 size;            
	UINT8  verify[16];      
} RTSC_STPC_PLAYREADY_VERIFY_LICENSE;
typedef struct STPC_PLAYREADY_PAYLOADINFO {
	UINT32 header_size;     
	UINT32 frame_size;      
	UINT32 footer_size;     
	UINT32 offset;          
	UINT8  iv[8];           
} STPC_PLAYREADY_PAYLOADINFO;
typedef struct RTSC_STPC_PLAYREADY_SET_PAYLOADINFO {
	UINT32 num;             
	STPC_PLAYREADY_PAYLOADINFO* payload_info; 
} RTSC_STPC_PLAYREADY_SET_PAYLOADINFO;
typedef struct RTSC_STPC_PLAYREADY_CHECK_DEVKEY {
	UINT32 type;            
	UINT8  privkey[32];     
	UINT8  pubkey[64];      
} RTSC_STPC_PLAYREADY_CHECK_DEVKEY;
typedef struct RTSC_STPC_PLAYREADY_VERIFY_SIGN {
	UINT8  pubkey[64];      
	UINT8  hash[32];        
	UINT8  sign[64];        
} RTSC_STPC_PLAYREADY_VERIFY_SIGN;
typedef struct RTSC_STPC_PLAYREADY_GENERATE_KEYFILE_SIGN {
	UINT8  *keyfile;        
	UINT32 size;            
	UINT8  sign[16];        
} RTSC_STPC_PLAYREADY_GENERATE_KEYFILE_SIGN;
typedef struct RTSC_STPC_PLAYREADY_MAKE_SST_KEY {
	UINT8  sstkey[16];      
} RTSC_STPC_PLAYREADY_MAKE_SST_KEY;
typedef struct RTSC_STPC_PLAYREADY_MAKE_SST_PASSWD {
	UINT8  sstkey[16];      
	UINT8  *data;           
	UINT32 size;            
	UINT8  passwd[16];      
} RTSC_STPC_PLAYREADY_MAKE_SST_PASSWD;
typedef struct RTSC_STPC_PLAYREADY_SET_SST_PASSWD {
	UINT8  passwd[16];      
} RTSC_STPC_PLAYREADY_SET_SST_PASSWD;
typedef struct RTSC_STPC_PLAYREADY_CALC_SST_HASH {
	UINT32       type;          
	UINT8        passwd[16];    
	RTSC_DATAPOS data;          
	UINT32       data_size;     
	UINT8        phase;         
	UINT8        *state;        
	UINT32       state_size;    
	UINT8        *hash;         
	UINT32       hash_size;     
} RTSC_STPC_PLAYREADY_CALC_SST_HASH;
#endif

typedef struct RTSC_STPC_REENC_DEVKEY {
        UINT32          type;           
        UINT8           *key;           
        UINT32          size;           
} RTSC_STPC_REENC_DEVKEY;

#endif
